% Model of a nonisothermal batch reactor - Strongly exothermic reaction

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

% data

clear all

tspan = 0:360:86400; % We want output every 5 min up to 1 day
cA0 = 6;             % Initial butene concentration (kmol/m3)
cB0 = 12;             % Initial isobutane concentration (kmol/m3)
cC0 = 0;             % Initial isooctane concentration (kmol/m3)

% k                  % Rate constant (m3/kg/s)
A = 4.41e5;
EA = 90000;

V = 10;              % Reactor volume (m3)
Ac = 8;              % Area of heating/cooling coil (m2)
U = 0.228;           % Heat transfer coefficient (kJ/m2 K)
Tc = 373.15;         % Temperature of heat transfer medium (K)

DH0 = -150000;       % Enthalpy of reaction at 25 C
Cpsum = 1500;        % Heat capacity (kJ/m3 K)

c0(1) = cA0;         % Running variable for cC4 is C(:,1)
c0(2) = 373.15;      % Running variable for T is C(:,2)

% Call of differential equation solver

options = odeset('RelTol', 1e-6, 'AbsTol', 1e-8, 'InitialStep', 0.01);
[T,C] = ode45(@f,tspan,c0,options,cA0,cB0,cC0,A,EA,V,Ac,U,Tc,DH0,Cpsum);

% Output

figure(1)
plot(T,C(:,1))
xlabel('Time (s)');
ylabel('Concentration of C4 (kmol/m3)');
figure(2)
plot(T,C(:,2))
xlabel('Time (s)');
ylabel('Temperature (K)');
T
C
[s1,s2] = size(T);
conversion = (C(1,1)-C(s1,1))/C(1,1)
